precision highp float;

varying vec2 v_texCoords;
varying vec4 v_position;
uniform sampler2D u_texture;

uniform sampler2D u_map;
uniform float u_map_size;
uniform float u_pixel;

// ------ optimized ----------

float sin2(float param)
{
    return param;
}

float asin2(float param)
{
    return param;
}

float tan2(float param)
{
    return param;
}

float atan2(float param)
{
    return param;
}

//---------- main -------------

void main()
{
    vec2 mapCoords = (1.0 - u_map_size) / 2.0 + v_texCoords * u_map_size;
    float r_index = 2.0;

    float r = texture2D(u_map, vec2(mapCoords.s, mapCoords.t)).r;
    vec2 diff = vec2(texture2D(u_map, vec2(mapCoords.s + u_pixel, mapCoords.t)).r - r,
                     texture2D(u_map, vec2(mapCoords.s, mapCoords.t + u_pixel)).r - r);

    vec2 angle = vec2(atan2(diff.x), atan2(diff.y));
    vec2 refraction = vec2(asin2(sin2(diff.x) / r_index), asin2(sin2(diff.y) / r_index));
    vec2 displacement = vec2(tan2(refraction.x) * diff.x, tan2(refraction.y) * diff.y);

    vec2 d_tex_coord;
    if (diff.x < 0.0) {
        // current position is higher - clockwise rotation
        if (diff.y < 0.0) {
            d_tex_coord = -displacement;
        } else {
            d_tex_coord = vec2(-displacement.x, displacement.y);
        }
    } else {
        // current position is lower - counterclockwise rotation
        if (diff.y < 0.0) {
            d_tex_coord = vec2(displacement.x, -displacement.y);
        } else {
            d_tex_coord = displacement;
        }
    }
    d_tex_coord *= 40.0;
    vec4 col = texture2D(u_texture, v_texCoords + d_tex_coord);
    col.rgb += clamp(r - 0.5, -0.01, 1.0) * 1.6;

    gl_FragColor = vec4(col.rgb * col.a, 1.0);
}
